# -*- coding: utf-8 -*-
"""葡月ERP - 认证路由"""

from flask import Blueprint, render_template, request, redirect, url_for, make_response
from datetime import datetime
from ..utils import load, save, get_current_user

auth_bp = Blueprint('auth', __name__)

# 内存中的会话存储
sessions = {}


@auth_bp.route('/login')
def login():
    user = get_current_user(sessions)
    if user and user.get('username') != 'guest':
        return redirect(url_for('main.home'))
    
    session_id = f"sess_auto_{datetime.now().strftime('%Y%m%d%H%M%S')}"
    sessions[session_id] = {
        'user_id': 1,
        'username': 'admin',
        'role': 'admin',
        'name': '管理员',
        'login_time': datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    }
    
    response = make_response(redirect(url_for('main.home')))
    response.set_cookie('session_id', session_id, max_age=86400)
    return response


@auth_bp.route('/logout')
def logout():
    session_id = request.cookies.get('session_id')
    if session_id and session_id in sessions:
        del sessions[session_id]
    response = make_response(redirect(url_for('auth.login')))
    response.set_cookie('session_id', '', expires=0)
    return response


def get_sessions():
    """获取会话存储"""
    return sessions
