# -*- coding: utf-8 -*-
"""葡月ERP - Flask配置"""

import os

class Config:
    """基础配置"""
    SECRET_KEY = os.environ.get('SECRET_KEY') or 'puyue-erp-secret-key-2024'
    JSON_AS_ASCII = False
    
    # 数据目录
    DATA_DIR = "/root/data/disk/clawde/workspace/users/wecom_GuSi/data"
    BACKUP_DIR = "/root/data/disk/clawde/workspace/users/wecom_GuSi/backups"
    
    # 模板目录
    TEMPLATE_FOLDER = "/root/data/disk/clawde/workspace/users/wecom_GuSi/templates"
    
    # 文件映射
    FILES = {
        'inventory': 'inventory.json',
        'sales': 'sales.json',
        'purchase': 'purchase.json',
        'customers': 'customers.json',
        'config': 'config.json',
        'expenses': 'expenses.json',
        'stock_check': 'stock_check.json',
        'budget': 'budget.json',
        'transactions': 'transactions.json',
        'users': 'users.json'
    }
    
    # 权限配置
    ROLE_PERMISSIONS = {
        "admin": ["sales", "purchase", "inventory", "customers", "financial", "expenses", "backup", "users"],
        "manager": ["sales", "purchase", "inventory", "customers", "financial", "expenses", "backup"],
        "user": ["sales", "inventory", "customers"],
        "guest": []
    }
    
    # 模块列表
    ALL_MODULES = {
        "sales": "📋 销售订单",
        "purchase": "📥 采购管理",
        "inventory": "📦 库存管理",
        "customers": "👥 客户管理",
        "financial": "💰 财务管理",
        "expenses": "📝 费用报销",
        "backup": "💾 数据备份",
        "users": "👨‍💼 用户管理"
    }


class DevelopmentConfig(Config):
    """开发环境"""
    DEBUG = True


class ProductionConfig(Config):
    """生产环境"""
    DEBUG = False


config = {
    'development': DevelopmentConfig,
    'production': ProductionConfig,
    'default': DevelopmentConfig
}
