# -*- coding: utf-8 -*-
"""葡月ERP - Flask应用工厂"""

from flask import Flask
import os


def create_app(config_name='production'):
    """应用工厂函数"""
    # 加载配置
    from .config import config
    cfg = config.get(config_name, config['default'])
    
    # 创建Flask应用，指定模板目录
    app = Flask(__name__, template_folder=cfg.TEMPLATE_FOLDER)
    app.config.from_object(cfg)
    
    # 确保数据目录存在
    os.makedirs(app.config['DATA_DIR'], exist_ok=True)
    os.makedirs(app.config['BACKUP_DIR'], exist_ok=True)
    
    # 注册蓝图
    from .routes import auth_bp, main_bp, inventory_bp, purchase_bp, customers_bp, users_bp, expenses_bp, financial_bp, backup_bp
    
    app.register_blueprint(auth_bp, url_prefix='')
    app.register_blueprint(main_bp)
    app.register_blueprint(inventory_bp)
    app.register_blueprint(purchase_bp)
    app.register_blueprint(customers_bp)
    app.register_blueprint(users_bp)
    app.register_blueprint(expenses_bp)
    app.register_blueprint(financial_bp)
    app.register_blueprint(backup_bp)
    
    return app
